% Multivariate HP filter

function HP1 = HP_2dim(Bmat,lambda)

    T1 = size(Bmat,1);
    T2 = size(Bmat,2);
    B = Bmat(:);

    AA = zeros(T1*T2,T1*T2);

% SEGMENT 1: t1,t2 \in [3,T-2]
    for t1 = 3:T1-2
        for t2 = 3:T2-2
            row = (t1-1)*T2 + t2;

            pos_t1 = (t1+[-2 -1 0 1 2]-1)*T1+t2;
            pos_t2 = row + [-2 -1 0 1 2];

            AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 6 -4 1]; 
            AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 6 -4 1]; 
        end
    end

% SEGMENT 2: t1=1 or t1=T,t2 \in [3,T-2] and vice-versa

    for t2 = 3:T2-2
        t1 = 1; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[0 1 2]-1)*T1+t2;
        pos_t2 = row + [-2 -1 0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -2 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 6 -4 1]; 
        
        t1 = T1; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[-2 -1 0]-1)*T1+t2;
        pos_t2 = row + [-2 -1 0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -2 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 6 -4 1];         
    end
    
    for t1 = 3:T1-2
        t2 = 1; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[-2 -1 0 1 2]-1)*T1+t2;
        pos_t2 = row + [0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 6 -4 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -2 1]; 
        
        t2 = T2; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[-2 -1 0 1 2]-1)*T1+t2;
        pos_t2 = row + [-2 -1 0];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 6 -4 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -2 1];         
    end
    
% SEGMENT 3: t1=2 or t1=T-1,t2 \in [3,T-2] and vice-versa

    for t2 = 3:T2-2
        t1 = 2; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1-1+[-1 0 1 2])*T1+t2;
        pos_t2 = row + [-2 -1 0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[-2 5 -4 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 6 -4 1]; 
        
        t1 = T1-1; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1-1+[-2 -1 0 1])*T1+t2;
        pos_t2 = row + [-2 -1 0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 5 -2]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 6 -4 1];         
    end
    
    for t1 = 3:T1-2
        t2 = 2; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[-2 -1 0 1 2]-1)*T1+t2;
        pos_t2 = row + [-1 0 1 2];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 6 -4 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[-2 5 -4 1]; 
        
        t2 = T2-1; 
        row = (t1-1)*T1+t2;

        pos_t1 = (t1+[-2 -1 0 1 2]-1)*T1+t2;
        pos_t2 = row + [-2 -1 0 1];

        AA(row,pos_t1) =AA(row,pos_t1)+ lambda*[1 -4 6 -4 1]; 
        AA(row,pos_t2) =AA(row,pos_t2)+ lambda*[1 -4 5 -2];         
    end
    
% CORNERS: (1,1),(T,T),(1,T),(T,1)

    t1 = 1; t2=1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[0 1 2]-1)*T1+t2;
    pos_t2 = row + [0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];

    t1 = 1; t2=T2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[0 1 2]-1)*T1+t2;
    pos_t2 = row + [-2 -1 0];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];

    t1=T1; t2=1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[-2 -1 0]-1)*T1+t2;
    pos_t2 = row + [0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];

    t1=T1; t2=T2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[-2 -1 0]-1)*T1+t2;
    pos_t2 = row + [-2 -1 0];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];

% CORNERS: (2,2),(T-1,T-1),(2,T-1),(T-1,2)
    t1 = 2; t2=2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-1 0 1 2])*T1+t2;
    pos_t2 = row + [-1 0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[-2 5 -4 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[-2 5 -4 1];

    t1 = 2; t2=T2-1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-1 0 1 2])*T1+t2;
    pos_t2 = row + [-2 -1 0 1];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[-2 5 -4 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -4 5 -2];

    t1 = T1-1; t2=2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-2 -1 0 1])*T1+t2;
    pos_t2 = row + [-1 0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -4 5 -2]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[-2 5 -4 1];

    t1 = T1-1; t2=T2-1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-2 -1 0 1])*T1+t2;
    pos_t2 = row + [-2 -1 0 1];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -4 5 -2]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -4 5 -2];

% CORNERS: (1,2),(2,1),(1,T-1),(T-1,1),etc
    t1 = 1; t2 = 2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[0 1 2])*T1+t2;
    pos_t2 = row + [-1 0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[-2 5 -4 1];
    
    t1 = 1; t2 = T2-1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[0 1 2])*T1+t2;
    pos_t2 = row + [-2 -1 0 1];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -4 5 -2];

    t1 = 2; t2 = 1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-1 0 1 2])*T1+t2;
    pos_t2 = row + [0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[-2 5 -4 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1]; 

    t1 = 2; t2 = T2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-1 0 1 2])*T1+t2;
    pos_t2 = row + [-2 -1 0]; 
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[-2 5 -4 1]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];
    
    t1 = T1-1; t2 = 1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-2 -1 0 1])*T1+t2;
    pos_t2 = row + [0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -4 5 -2]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1]; 
    
    t1 = T1-1; t2 = T2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1-1+[-2 -1 0 1])*T1+t2;
    pos_t2 = row + [-2 -1 0];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -4 5 -2]; 
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -2 1];
    
    t1 = T1; t2 = 2;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[-2 -1 0]-1)*T1+t2;
    pos_t2 = row + [-1 0 1 2];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1];   
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[-2 5 -4 1];

    t1 = T1; t2 = T2-1;
    row = (t1-1)*T1+t2;
    pos_t1 = (t1+[-2 -1 0]-1)*T1+t2;
    pos_t2 = row + [-2 -1 0 1];
    AA(row,pos_t1) = AA(row,pos_t1)+ lambda*[1 -2 1];   
    AA(row,pos_t2) = AA(row,pos_t2)+ lambda*[1 -4 5 -2];
        
    % ADD 1 TO THE DIAGONAL
    %AA = AA+diag(ones(1,T1*T2));
    diag_elements = ([1:1:T1*T2]-1)*T1*T2 + [1:1:T1*T2];
    AA(diag_elements) = AA(diag_elements)+1;

    % INVERSE OF THE MATRIX
    AAs = sparse(AA);
    ASinv = inv(AAs);
    Ainv = full(ASinv);
    
    % RESHAPE
    HP = Ainv*B;
    HP1 = reshape(HP,T1,T2);
return
